<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PDF;

class ReportController extends Controller
{
      public function index(Request $request)
    {
        $reportType = $request->get('report_type', 'inward');
        $search = $request->get('search', '');
        $limit = 10;

        if ($reportType === 'inward') {
            $query = DB::table('purchase_stock as p')
                ->leftJoin(DB::raw('(SELECT purchase_stock_id, SUM(qty) as fault_qty FROM fault_stock GROUP BY purchase_stock_id) f'), 'p.id', '=', 'f.purchase_stock_id')
                ->leftJoin(DB::raw('(SELECT purchase_stock_id, SUM(qty) as outward_qty FROM outward_stock GROUP BY purchase_stock_id) o'), 'p.id', '=', 'o.purchase_stock_id')
                ->select(
                    'p.item_name',
                    'p.particular_name',
                    'p.specification',
                    'p.model_number',
                    DB::raw('SUM(p.qty) as purchased_qty'),
                    DB::raw('COALESCE(SUM(f.fault_qty),0) as fault_count'),
                    DB::raw('COALESCE(SUM(o.outward_qty),0) as outward_qty'),
                    DB::raw('(SUM(p.qty) - COALESCE(SUM(f.fault_qty),0) - COALESCE(SUM(o.outward_qty),0)) as available_stock')
                )
                ->groupBy('p.item_name','p.particular_name','p.specification','p.model_number');

            if ($search) {
                $query->where(function($q) use ($search) {
                    $q->where('p.item_name','like',"%$search%")
                      ->orWhere('p.particular_name','like',"%$search%")
                      ->orWhere('p.specification','like',"%$search%")
                      ->orWhere('p.model_number','like',"%$search%");
                });
            }

            $records = $query->paginate($limit)->appends($request->all());

            $columns = [
                'item_name' => 'Item',
                'particular_name' => 'Particular',
                'specification' => 'Specification',
                'model_number' => 'Model',
                'purchased_qty' => 'Inward',
                'outward_qty' => 'Outward',
                'fault_count' => 'Fault',
                'available_stock' => 'Available Stock'
            ];
        } else {
            $query = DB::table('outward_stock')->orderByDesc('id');

            if ($search) {
                $query->where(function($q) use ($search) {
                    $q->where('item_name','like',"%$search%")
                      ->orWhere('particular_name','like',"%$search%")
                      ->orWhere('specification','like',"%$search%")
                      ->orWhere('model_number','like',"%$search%")
                      ->orWhere('given_to','like',"%$search%")
                      ->orWhere('remarks','like',"%$search%");
                });
            }

            $records = $query->paginate($limit)->appends($request->all());

            $columns = [
                'outward_date' => 'Date',
                'given_to' => 'Given To',
                'item_name' => 'Item',
                'particular_name' => 'Particular',
                'specification' => 'Specification',
                'model_number' => 'Model',
                'qty' => 'Quantity',
                'remarks' => 'Remarks'
            ];
        }

        return view('reports', compact('records','columns','reportType','search'));
    }

    public function exportPdf(Request $request)
    {
        $reportType = $request->get('report_type','inward');
        $search = $request->get('search','');

        // Reuse same query as above but without paginate
        if ($reportType === 'inward') {
            $query = DB::table('purchase_stock as p')
                ->leftJoin(DB::raw('(SELECT purchase_stock_id, SUM(qty) as fault_qty FROM fault_stock GROUP BY purchase_stock_id) f'), 'p.id', '=', 'f.purchase_stock_id')
                ->leftJoin(DB::raw('(SELECT purchase_stock_id, SUM(qty) as outward_qty FROM outward_stock GROUP BY purchase_stock_id) o'), 'p.id', '=', 'o.purchase_stock_id')
                ->select(
                    'p.item_name',
                    'p.particular_name',
                    'p.specification',
                    'p.model_number',
                    DB::raw('SUM(p.qty) as purchased_qty'),
                    DB::raw('COALESCE(SUM(f.fault_qty),0) as fault_count'),
                    DB::raw('COALESCE(SUM(o.outward_qty),0) as outward_qty'),
                    DB::raw('(SUM(p.qty) - COALESCE(SUM(f.fault_qty),0) - COALESCE(SUM(o.outward_qty),0)) as available_stock')
                )
                ->groupBy('p.item_name','p.particular_name','p.specification','p.model_number');

            if ($search) {
                $query->where(function($q) use ($search) {
                    $q->where('p.item_name','like',"%$search%")
                      ->orWhere('p.particular_name','like',"%$search%")
                      ->orWhere('p.specification','like',"%$search%")
                      ->orWhere('p.model_number','like',"%$search%");
                });
            }

            $records = $query->get();

            $columns = [
                'item_name' => 'Item',
                'particular_name' => 'Particular',
                'specification' => 'Specification',
                'model_number' => 'Model',
                'purchased_qty' => 'Inward',
                'outward_qty' => 'Outward',
                'fault_count' => 'Fault',
                'available_stock' => 'Available Stock'
            ];
        } else {
            $query = DB::table('outward_stock')->orderByDesc('id');
            if ($search) {
                $query->where(function($q) use ($search) {
                    $q->where('item_name','like',"%$search%")
                      ->orWhere('particular_name','like',"%$search%")
                      ->orWhere('specification','like',"%$search%")
                      ->orWhere('model_number','like',"%$search%")
                      ->orWhere('given_to','like',"%$search%")
                      ->orWhere('remarks','like',"%$search%");
                });
            }

            $records = $query->get();

            $columns = [
                'outward_date' => 'Date',
                'given_to' => 'Given To',
                'item_name' => 'Item',
                'particular_name' => 'Particular',
                'specification' => 'Specification',
                'model_number' => 'Model',
                'qty' => 'Quantity',
                'remarks' => 'Remarks'
            ];
        }

        $pdf = PDF::loadView('reports_pdf', compact('records','columns','reportType'));
        return $pdf->download($reportType.'_report_'.date('YmdHis').'.pdf');
    }
}
