<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ReturnController extends Controller
{
       public function create()
    {
        $os_numbers = DB::table('outward_stock')
            ->orderBy('id', 'DESC')
            ->pluck('os_number');

        return view('return_products', compact('os_numbers'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'return_date' => 'required|date',
            'os_number'   => 'required',
            'given_to'    => 'required|string',
            'purchase_stock_id' => 'required|integer',
            'item_name'   => 'required|string',
            'particular_name' => 'required|string',
            'specification'   => 'required|string',
            'model_number'    => 'required|string',
            'qty'        => 'required|integer|min:1',
            'status'     => 'required',
            'remarks'    => 'nullable|string'
        ]);

        $purchase_id = $data['purchase_stock_id'];
        $os_number   = $data['os_number'];
        $qty         = $data['qty'];

        // Step 1: Reduce outward_stock
        $outward = DB::table('outward_stock')
            ->where('os_number', $os_number)
            ->where('purchase_stock_id', $purchase_id)
            ->first();

        if ($outward) {
            if ($qty < $outward->qty) {
                DB::table('outward_stock')->where('id', $outward->id)
                    ->update(['qty' => $outward->qty - $qty]);
            } else {
                DB::table('outward_stock')->where('id', $outward->id)->delete();
            }
        }

        // Step 2: If Not OK → Insert into fault_stock + update purchase_stock
        if ($data['status'] === 'Not OK') {
            DB::table('fault_stock')->insert([
                'fault_date'      => $data['return_date'],
                'given_to'        => $data['given_to'],
                'purchase_stock_id' => $purchase_id,
                'item_name'       => $data['item_name'],
                'particular_name' => $data['particular_name'],
                'specification'   => $data['specification'],
                'model_number'    => $data['model_number'],
                'qty'             => $qty,
                'remarks'         => $data['remarks'],
                'company_name'    => 'Nilatech',
            ]);

            DB::table('purchase_stock')->where('id', $purchase_id)
                ->update([
                    'fault_count' => DB::raw("IFNULL(fault_count,0) + $qty")
                ]);
        }

        return redirect()->route('outward_view')->with('success', 'Product return processed successfully!');
    }
public function getOutwardByOs(Request $request)
{
    $os_number = $request->input('os_number');
    Log::info("osnumber: ".$os_number);

    $data = DB::table('outward_stock')
        ->join('purchase_stock', 'outward_stock.purchase_stock_id', '=', 'purchase_stock.id')
        ->select(
            'outward_stock.given_to',
            'outward_stock.qty',
            'outward_stock.purchase_stock_id',
            'purchase_stock.item_name',
            'purchase_stock.particular_name',
            'purchase_stock.specification',
            'purchase_stock.model_number'
        )
        ->where('outward_stock.os_number', $os_number)
        ->first();

    Log::info("data: ".json_encode($data));

    return response()->json($data);
}

}
