<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FaultStock extends Model
{
    protected $table = 'fault_stock';
    protected $fillable = [
        'fault_date','given_to','qty','remarks',
        'item_name','particular_name','specification','model_number',
        'purchase_stock_id','updated_at','company_name'
    ];
      public $timestamps = false; 

    public function purchaseStock()
    {
        return $this->belongsTo(PurchaseStock::class, 'purchase_stock_id');
    }
}
