<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseInvoice extends Model
{
  use HasFactory;

    protected $table = 'purchase_invoice';
    protected $fillable = [
        'company_name',
        'invoice_number',
        'incoming_date',
        'courier_name',
        'courier_charge',
        'total_amount'
    ];
      public $timestamps = false; 

    public function stocks()
    {
        return $this->hasMany(PurchaseStock::class, 'purchase_invoice_id');
    }
}
