<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseStock extends Model
{
  protected $table = 'purchase_stock';
    protected $fillable = [
        'purchase_invoice_id',
        'item_name',
        'particular_name',
        'specification',
        'model_number',
        'qty',
        'rate',
        'gst',
        'total',
        'fault_count',
        'company_name',
        'invoice_number',
        'incoming_date',
        'courier_name'
    ];
      public $timestamps = false; 

    public function invoice()
    {
        return $this->belongsTo(PurchaseInvoice::class, 'purchase_invoice_id');
    }

       public function faultStocks()
    {
        return $this->hasMany(FaultStock::class, 'purchase_stock_id');
    }

    public function outwardStocks()
    {
        return $this->hasMany(OutwardStock::class, 'purchase_stock_id');
    }

 

}
