<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Login - Inventory</title>
    <link rel="icon" type="image/png" href="{{ asset('assets/logo_icon.png') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light" style="margin:0; display:flex; flex-direction:column; min-height:100vh;">

    <div style="flex:1;">
        <div class="container mt-5" style="max-width: 400px;">
            <div class="text-center mb-4">
                <a class="navbar-brand" href="{{ url('/inventory') }}">
                  <img src="{{ asset('assets/logo.png') }}" alt="Logo" height="60">


                </a>
            </div>

            <h3 class="text-center mb-4">Login</h3>

            @if(session('error'))
                <div class="alert alert-danger text-center">{{ session('error') }}</div>
            @endif
            @if(session('success'))
                <div class="alert alert-success text-center">{{ session('success') }}</div>
            @endif

            <form method="POST" action="{{ url('/login') }}" class="card p-4 shadow">
                @csrf
                <div class="mb-3">
                    <label class="form-label">Username</label>
                    <input type="text" name="username" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input type="password" name="password" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-success w-100">Login</button>
            </form>
        </div>
    </div>

    <footer style="background:#f8f9fa; text-align:center; padding:10px 0;">
        Powered By <img src="{{ asset('assets/logo.png') }}" alt="Logo" style="height:20px; vertical-align:middle;">
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
