@extends('layouts.app')

@section('content')
<div class="container mt-2">
    <h2 class="mb-4 text-center text-success">Stock Categories</h2>

    <div class="stock-tree">
        @foreach($tree as $item => $particulars)
            <div class="tree-item">
                <div class="tree-header" onclick="toggleTree(this)">
                    <strong>{{ $item }}</strong>
                </div>
                <div class="tree-children">
                    @foreach($particulars as $part => $specs)
                        <div class="tree-item">
                            <div class="tree-header" onclick="toggleTree(this)">
                                {{ $part }}
                            </div>
                            <div class="tree-children">
                                @foreach($specs as $spec => $models)
                                    <div class="tree-item">
                                        <div class="tree-header" onclick="toggleTree(this)">
                                            {{ $spec }}
                                        </div>
                                        <div class="tree-children">
                                            @foreach($models as $m)
                                                <div class="tree-leaf">
                                                    {{ $m['model'] }}
                                                    @if($m['available'] > 0)
                                                        <span class="text-success">(Available: {{ $m['available'] }})</span>
                                                    @else
                                                        <span class="text-danger">(Available: {{ $m['available'] }})</span>
                                                    @endif
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach
    </div>
</div>

<style>
.stock-tree .tree-item {
    margin-left: 1rem;
    border-left: 2px solid #ddd;
    padding-left: 0.5rem;
    margin-bottom: 0.3rem;
}
.stock-tree .tree-header {
    cursor: pointer;
    padding: 0.2rem 0.5rem;
    background: #f1f1f1;
    border-radius: 4px;
    margin-bottom: 0.2rem;
}
.stock-tree .tree-header:hover { background: #e0e0e0; }
.stock-tree .tree-children { display: none; margin-left: 1rem; }
.stock-tree .tree-leaf { padding: 0.1rem 0.5rem; }
.text-success { color: green; font-weight: bold; }
.text-danger { color: red; font-weight: bold; }
</style>

<script>
function toggleTree(header) {
    const children = header.nextElementSibling;
    if(children){
        children.style.display = children.style.display === 'block' ? 'none' : 'block';
    }
}
</script>

 <footer class="text-center py-3  bg-white" style="margin-top: 450px;" >
        Powered By <img src="{{ asset('assets/logo.png') }}" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>
@endsection
