@extends('layouts.app')

@section('content')
<div class="container mt-3">
    <h2 class="text-center text-success mb-4">Edit Product</h2>

    @if(session('success'))
        <div class="alert alert-success text-center">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger text-center">{{ session('error') }}</div>
    @endif

    <form method="POST" action="{{ route('stock.update', $product->id) }}">
        @csrf
        @method('PUT')

        <div class="row g-3 mb-3">
            <div class="col-md-4">
                <label class="form-label">Invoice Number</label>
                <input type="text" class="form-control" name="invoice_number" value="{{ old('invoice_number', $product->invoice_number) }}" required>
            </div>
            <div class="col-md-4">
                <label class="form-label">Date</label>
                <input type="date" class="form-control" name="incoming_date" value="{{ old('incoming_date', $product->incoming_date) }}" required>
            </div>
            <div class="col-md-4">
                <label class="form-label">Courier Name</label>
                <input type="text" class="form-control" name="courier_name" value="{{ old('courier_name', $product->courier_name) }}">
            </div>
        </div>

        <div class="row g-3 mb-3">
            <div class="col-md-4">
                <label class="form-label">Company Name</label>
                <input type="text" class="form-control" name="company_name" value="{{ old('company_name', $product->company_name) }}" required>
            </div>
            <div class="col-md-4">
                <label class="form-label">Item Name</label>
                <input type="text" class="form-control" name="item_name" value="{{ old('item_name', $product->item_name) }}" required>
            </div>
            <div class="col-md-4">
                <label class="form-label">Particular</label>
                <input type="text" class="form-control" name="particular_name" value="{{ old('particular_name', $product->particular_name) }}">
            </div>
        </div>

        <div class="row g-3 mb-3">
            <div class="col-md-4">
                <label class="form-label">Specification</label>
                <input type="text" class="form-control" name="specification" value="{{ old('specification', $product->specification) }}">
            </div>
            <div class="col-md-4">
                <label class="form-label">Model</label>
                <input type="text" class="form-control" name="model_number" value="{{ old('model_number', $product->model_number) }}">
            </div>
        </div>

        <div class="row g-3 mb-3">
            <div class="col-md-2">
                <label class="form-label">Qty</label>
                <input type="number" class="form-control" name="qty" id="qty" value="{{ old('qty', $product->qty) }}" min="0" step="any" required>
            </div>
            <div class="col-md-2">
                <label class="form-label">Rate</label>
                <input type="number" step="0.01" class="form-control" name="rate" value="{{ old('rate', $product->rate) }}" required>
            </div>
            <div class="col-md-2">
                <label class="form-label">GST %</label>
                <input type="number" step="0.01" class="form-control" name="gst" value="{{ old('gst', $product->gst) }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">Fault Count</label>
                <input type="number" class="form-control" name="fault_count" id="fault_count" value="{{ old('fault_count', $product->fault_count ?? 0) }}" min="0">
                <small class="text-muted" id="availableText">Available: {{ $available }}</small>
            </div>
        </div>

        <div class="mb-3">
            <label class="form-label">Fault Remarks</label>
            <textarea class="form-control" name="remarks" rows="2">{{ old('remarks', $faultRemark) }}</textarea>
        </div>

        <div class="text-center mt-3">
            <button type="submit" class="btn btn-success">Update Product</button>
            <a href="{{ url('inventory') }}" class="btn btn-secondary">Back</a>
        </div>
    </form>
</div>

 <footer class="text-center py-3  bg-white" style="margin-top: 10px;" >
        Powered By <img src="{{ asset('assets/logo.png') }}" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>
@endsection
