@extends('layouts.app')

@section('content')
<div class="container mt-2">
    <h2 class="mb-3 text-center text-danger">Fault Stock View</h2>

    <!-- Filter Form -->
    <form method="GET" class="row g-3 mb-4">
        <div class="col-md-3">
            <input type="text" class="form-control" name="item_name"
                   placeholder="Filter by Item" value="{{ request('item_name') }}">
        </div>
        <div class="col-md-3">
            <input type="text" class="form-control" name="given_to"
                   placeholder="Filter by Given To" value="{{ request('given_to') }}">
        </div>
        <div class="col-md-3">
            <input type="date" class="form-control" name="fault_date"
                   value="{{ request('fault_date') }}">
        </div>
        <div class="col-md-3 d-flex gap-2">
            <button class="btn btn-danger" type="submit">Filter</button>
            <a href="{{ route('fault_view') }}" class="btn btn-secondary">Reset</a>
        </div>
    </form>

    <!-- Table -->
    <table class="table table-bordered table-striped shadow-sm">
        <thead class="table-dark text-center">
            <tr>
                <th>ID</th>
                <th>Invoice Number</th>
                <th>Fault Date</th>
                <th>Given To</th>
                <th>Item</th>
                <th>Particular</th>
                <th>Specification</th>
                <th>Model</th>
                <th>Qty</th>
                <th>Remarks</th>
            </tr>
        </thead>
        <tbody>
            @forelse($faults as $row)
                <tr>
                    <td>{{ $row->id }}</td>
                    <td>{{ $row->purchaseStock->invoice_number ?? 'N/A' }}</td>
                    <td>{{ $row->fault_date }}</td>
                    <td>{{ $row->given_to }}</td>
                    <td>{{ $row->purchaseStock->item_name ?? $row->item_name }}</td>
                    <td>{{ $row->purchaseStock->particular_name ?? $row->particular_name ?? '0' }}</td>
                    <td>{{ $row->purchaseStock->specification ?? $row->specification ?? '0' }}</td>
                    <td>{{ $row->purchaseStock->model_number ?? $row->model_number ?? '0' }}</td>
                    <td>{{ $row->qty ?? '0' }}</td>
                    <td>{{ $row->remarks }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="10" class="text-center text-danger">No records found</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    {{ $faults->withQueryString()->links() }}
</div>

 <footer class="text-center py-3  bg-white" style="margin-top: 380px;" >
        Powered By <img src="{{ asset('assets/logo.png') }}" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>
@endsection
