@extends('layouts.app')

@section('content')
<div class="container mt-2">
    <h2 class="text-center text-success mb-4" style="margin-top:-10px;">Inventory Stock</h2>

    <!-- Filters -->
    <form method="GET" action="{{ route('inventory') }}" class="row g-3 mb-4 justify-content-center">
        <div class="col-md-2" style="margin-right: -5px;">
            <input type="text" class="form-control" name="invoice_number" placeholder="Filter by Invoice"
                   value="{{ request('invoice_number') }}">
        </div>
        <div class="col-md-2" style="margin-right: -5px;">
            <input type="text" class="form-control" name="item_name" placeholder="Filter by Item"
                   value="{{ request('item_name') }}">
        </div>
        <div class="col-md-2"style="margin-right: -5px;">
            <input type="date" class="form-control" name="incoming_date" value="{{ request('incoming_date') }}">
        </div>
        <div class="col-md-3 d-flex gap-2" >
            <button class="btn btn-success" type="submit">Filter</button>
            <a href="{{ route('inventory') }}" class="btn btn-secondary">Reset</a>
        </div>
    </form>

    <!-- Inventory Table -->
    <table class="table table-bordered table-striped shadow-sm">
        <thead class="table-dark text-center">
            <tr>
                <th>Invoice</th>
                <th>Date</th>
                <th>Courier</th>
                <th>Item</th>
                <th>Particular</th>
                <th>Specification</th>
                <th>Model</th>
                <th>Purchased Qty</th>
                <th>Outward Qty</th>
                <th>Fault Qty</th>
                <th>Available Stock</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        @forelse ($stocks as $row)
            @php
                $purchased = (int)$row->purchased_qty;
                $outward   = (int)$row->outward_qty;
                $fault     = (int)$row->fault_qty;
                $available = $purchased - ($outward + $fault);
            @endphp
            <tr>
                <td>{{ $row->invoice_number }}</td>
                <td>{{ $row->incoming_date }}</td>
                <td>{{ $row->courier_name }}</td>
                <td>{{ $row->item_name }}</td>
                <td>{{ $row->particular_name }}</td>
                <td>{{ $row->specification }}</td>
                <td>{{ $row->model_number }}</td>
                <td class="text-center">{{ $purchased }}</td>
                <td class="text-center">{{ $outward }}</td>
                <td class="text-center">{{ $fault }}</td>
                <td class="text-center fw-bold {{ $available <= 0 ? 'text-danger' : 'text-success' }}">
                    {{ $available }}
                </td>
                <td class="text-center">
                    <a href="{{ url('edit_product/'.$row->id.'/edit') }}" class="btn btn-sm btn-warning">Edit</a>
                    <form action="{{ url('delete_product/'.$row->id) }}" method="POST" class="d-inline"
                          onsubmit="return confirm('Are you sure you want to delete this record?')">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-sm btn-danger">Delete</button>
                    </form>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="12" class="text-center text-danger">No records found</td>
            </tr>
        @endforelse
        </tbody>
    </table>

    <div class="d-flex justify-content-center">
        {{ $stocks->links() }}
    </div>
</div>

 <footer class="text-center py-3  bg-white" style="margin-top: 315px;" >
        Powered By <img src="{{ asset('assets/logo.png') }}" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>


@endsection