@extends('layouts.app')

@section('title','Outward Stock Entry')

@section('content')
<div class="container mt-4">
    <h2 class="text-center text-success">Outward Stock Entry</h2>

    @if(session('success'))
        <div class="alert alert-success text-center">{{ session('success') }}</div>
    @elseif(session('error'))
        <div class="alert alert-danger text-center">{{ session('error') }}</div>
    @endif

    <form method="POST" action="{{ route('outward.store') }}" class="row g-2 shadow p-3 bg-white rounded">
        @csrf

        <div class="col-md-4">
            <label class="form-label">Outward Date</label>
            <input type="date" class="form-control" name="outward_date" required>
        </div>
        <div class="col-md-4">
            <label class="form-label">Given To</label>
            <input type="text" class="form-control" name="given_to" required>
        </div>
        <div class="col-md-4">
            <label class="form-label">Item</label>
            <select name="purchase_stock_id" class="form-select" required onchange="updateQtyLimit(this)">
                <option value="">-- Select Item --</option>
                @foreach($items as $item)
                    <option value="{{ $item->purchase_stock_id }}" data-available="{{ $item->available_qty }}">
                        {{ $item->item_name }} | {{ $item->particular_name }} | {{ $item->specification }} | {{ $item->model_number }} (Available: {{ $item->available_qty }})
                    </option>
                @endforeach
            </select>
        </div>

        <div class="col-md-4">
            <label class="form-label">Quantity</label>
            <input type="number" class="form-control" id="qtyInput" name="qty" min="1" required>
            <small class="text-muted" id="availableInfo"></small>
        </div>
        <div class="col-md-4">
            <label class="form-label">Remarks</label>
            <input type="text" class="form-control" name="remarks">
        </div>
        <div class="col-12 text-center">
            <button type="submit" class="btn btn-success">Submit</button>
        </div>
    </form>
</div>

 <footer class="text-center py-3  bg-white" style="margin-top: 310px;" >
        Powered By <img src="{{ asset('assets/logo.png') }}" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>
<script>
function updateQtyLimit(sel){
    const available = sel.options[sel.selectedIndex].getAttribute('data-available');
    const qtyInput = document.getElementById('qtyInput');
    const info = document.getElementById('availableInfo');
    if(available){
        qtyInput.max = available;
        qtyInput.value = (available > 0 ? 1 : 0);
        info.innerText = "Available: " + available;
    } else {
        qtyInput.max = 0;
        qtyInput.value = 0;
        info.innerText = "";
    }
}
</script>
@endsection
