@extends('layouts.app')

@section('content')
<div class="container mt-2">
    <h2 class="mb-4 text-center text-success">Outward Stock View</h2>

    <!-- Filter Form -->
    <form method="GET" class="row g-3 mb-4">
        <div class="col-md-3">
            <input type="text" class="form-control" name="item_name" placeholder="Filter by Item" value="{{ request('item_name') }}">
        </div>
        <div class="col-md-3">
            <input type="text" class="form-control" name="given_to" placeholder="Filter by Given To" value="{{ request('given_to') }}">
        </div>
        <div class="col-md-3">
            <input type="date" class="form-control" name="outward_date" value="{{ request('outward_date') }}">
        </div>
        <div class="col-md-3 d-flex gap-2">
            <button class="btn btn-success" type="submit">Filter</button>
            <a href="{{ route('outward_view') }}" class="btn btn-secondary">Reset</a>
        </div>
    </form>

    <!-- Table -->
    <table class="table table-bordered table-striped shadow-sm">
        <thead class="table-dark text-center">
            <tr>
                <th>OS Number</th>
                <th>Invoice</th>
                <th>Outward Date</th>
                <th>Given To</th>
                <th>Item</th>
                <th>Particular</th>
                <th>Specification</th>
                <th>Model</th>
                <th>Qty</th>
                <th>Remarks</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($stocks as $row)
                <tr>
                    <td>{{ $row->os_number }}</td>
                    <td>{{ $row->purchaseStock->invoice_number ?? 'N/A' }}</td>
                    <td>{{ $row->outward_date }}</td>
                    <td>{{ $row->given_to }}</td>
                    <td>{{ $row->purchaseStock->item_name ?? '' }}</td>
                    <td>{{ $row->purchaseStock->particular_name ?? '' }}</td>
                    <td>{{ $row->purchaseStock->specification ?? '' }}</td>
                    <td>{{ $row->purchaseStock->model_number ?? '' }}</td>
                    <td>{{ $row->qty }}</td>
                    <td>{{ $row->remarks }}</td>
                    <td class="text-center">
                        <a href="{{ url('outward/'.$row->id.'/edit') }}" class="btn btn-sm btn-warning">Edit</a>
                        <button class="btn btn-sm btn-danger delete-btn" data-id="{{ $row->id }}">Delete</button>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="11" class="text-center text-danger">No records found</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    {{ $stocks->withQueryString()->links() }}
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', function () {
            if (!confirm('Are you sure you want to delete this record?')) return;

            fetch(`/outward/${this.dataset.id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Content-Type': 'application/json'
                }
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) location.reload();
                else alert('Error deleting record');
            });
        });
    });
});
</script>

 <footer class="text-center py-3  bg-white" style="margin-top: 321px;" >
        Powered By <img src="{{ asset('assets/logo.png') }}" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>
@endsection
