@extends('layouts.app')

@section('content')
<div class="container mt-2">
    <h2 class="mb-4 text-center text-primary">Net Stock</h2>

    <form method="GET" id="searchForm" class="row g-3 mb-4 justify-content-center text-center">
        <div class="col-md-3">
            <select class="form-select" name="report_type" onchange="this.form.submit()">
                <option value="inward" {{ $reportType=='inward'?'selected':'' }}>Inward</option>
                <option value="outward" {{ $reportType=='outward'?'selected':'' }}>Outward</option>
            </select>
        </div>
        <div class="col-md-3">
            <input type="text" name="search" class="form-control" placeholder="Search"
                   value="{{ $search }}" onkeyup="this.form.submit()">
        </div>
        <div class="col-md-2 d-flex gap-2">
            <a href="{{ route('reports_pdf',['report_type'=>$reportType,'search'=>$search]) }}" class="btn btn-success">Export PDF</a>
        </div>
    </form>

    <div class="table-responsive shadow-sm bg-white rounded p-2">
        <table class="table table-bordered table-striped text-center">
            <thead class="table-dark">
                <tr>
                    @foreach($columns as $label)
                        <th>{{ $label }}</th>
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @forelse($records as $row)
                    <tr>
                        @foreach(array_keys($columns) as $col)
                            <td>{{ $row->$col ?? 0 }}</td>
                        @endforeach
                    </tr>
                @empty
                    <tr>
                        <td colspan="{{ count($columns) }}" class="text-center text-danger">No records found</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    {{ $records->links() }}
</div>

 <footer class="text-center py-3  bg-white" style="margin-top: 305px;" >
        Powered By <img src="{{ asset('assets/logo.png') }}" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>
@endsection
