<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\InventoryController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\OutwardStockController;
use App\Http\Controllers\ReturnController;
use App\Http\Controllers\FaultStockController;
use App\Http\Controllers\ReportController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/logout', [AuthController::class, 'logout'])->name('logout');

Route::get('/inventory', function () {
    return view('inventory');
})->middleware('authCheck');



Route::get('/inventory', [InventoryController::class, 'index'])->name('inventory');

Route::get('/purchase', [StockController::class, 'create'])->name('purchase.create');
Route::post('/purchase/store', [StockController::class, 'store'])->name('purchase.store');
Route::get('/edit_product/{id}/edit', [StockController::class, 'edit'])->name('edit_product');
Route::put('/stock/{id}', [StockController::class, 'update'])->name('stock.update');
Route::delete('delete_product/{id}',[StockController::class,'delete'])->name('delete_product');

Route::get('/outward',[OutwardStockController::class,'create'])->name('outward.create');
Route::post('/outward/store',[OutwardStockController::class,'store'])->name('outward.store');
Route::get('/outward_view', [OutwardStockController::class, 'index'])->name('outward_view');
Route::delete('/outward/{id}', [OutwardStockController::class, 'destroy'])->name('outward.destroy');

Route::get('/outward/{id}/edit', [OutwardStockController::class, 'edit'])->name('outward_edit');

Route::put('/outward/{id}', [OutwardStockController::class, 'update'])->name('outward_update');


Route::get('/return_products', [ReturnController::class, 'create'])->name('return.create');
Route::post('/return-products', [ReturnController::class, 'store'])->name('return.store');
Route::post('/get-outward-by-os', [ReturnController::class, 'getOutwardByOs'])->name('return.getOutward');

Route::get('/fault_view', [FaultStockController::class, 'index'])->name('fault_view');
Route::get('/categories',[FaultStockController::class,'categories'])->name('categories');
Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
Route::get('/reports_pdf', [ReportController::class, 'exportPdf'])->name('reports_pdf');