

<?php $__env->startSection('content'); ?>
<div class="container mt-2">
    <h2 class="mb-4 text-center text-success">Edit Outward Entry</h2>

    <?php if(session('error')): ?>
        <div class="alert alert-danger text-center"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('outward_update', $stock->id)); ?>" class="row g-3 shadow p-4 bg-white rounded">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="col-md-4">
            <label class="form-label">Outward Date</label>
            <input type="date" class="form-control" name="outward_date"
                   value="<?php echo e(old('outward_date', $stock->outward_date)); ?>" readonly>
        </div>
        <div class="col-md-4">
            <label class="form-label">Given To</label>
            <input type="text" class="form-control" name="given_to"
                   value="<?php echo e(old('given_to', $stock->given_to)); ?>" readonly>
        </div>
        <div class="col-md-4">
            <label class="form-label">Item</label>
            <input type="text" class="form-control" name="item_name"
                   value="<?php echo e(old('item_name', $stock->item_name)); ?>" readonly>
        </div>
        <div class="col-md-3">
            <label class="form-label">Particular</label>
            <input type="text" class="form-control" name="particular_name"
                   value="<?php echo e(old('particular_name', $stock->particular_name)); ?>" readonly>
        </div>
        <div class="col-md-3">
            <label class="form-label">Specification</label>
            <input type="text" class="form-control" name="specification"
                   value="<?php echo e(old('specification', $stock->specification)); ?>" readonly>
        </div>
        <div class="col-md-3">
            <label class="form-label">Model</label>
            <input type="text" class="form-control" name="model_number"
                   value="<?php echo e(old('model_number', $stock->model_number)); ?>" readonly>
        </div>
        <div class="col-md-2">
            <label class="form-label">Qty</label>
            <input type="number" class="form-control" name="qty"
                   value="<?php echo e(old('qty', $stock->qty)); ?>"
                   min="0" max="<?php echo e($available_qty); ?>" required>
            <small class="text-muted">Available: <?php echo e($available_qty); ?></small>
        </div>
        <div class="col-md-12">
            <label class="form-label">Remarks</label>
            <input type="text" class="form-control" name="remarks"
                   value="<?php echo e(old('remarks', $stock->remarks)); ?>">
        </div>
        <div class="col-12 text-center">
            <button type="submit" class="btn btn-success">Update Outward Entry</button>
            <a href="<?php echo e(route('outward_view')); ?>" class="btn btn-secondary">Back</a>
        </div>
    </form>
</div>
 <footer class="text-center py-3  bg-white" style="margin-top: 150px;" >
        Powered By <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Loganathan\Work\stockapp\resources\views/outward_edit.blade.php ENDPATH**/ ?>