

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h2 class="text-success text-center">Inward Stock Entry</h2>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="card shadow-sm">
        <div class="card-body">
            <form action="<?php echo e(route('purchase.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>

                <!-- Invoice Row -->
                <div class="row mb-3">
                    <div class="col-md-3">
                        <label>Invoice Number</label>
                        <input type="text" class="form-control" name="invoice_number" required>
                    </div>
                    <div class="col-md-3">
                        <label>Date</label>
                        <input type="date" class="form-control" name="incoming_date" required>
                    </div>
                    <div class="col-md-3">
                        <label>Courier Name</label>
                        <input type="text" class="form-control" name="courier_name">
                    </div>
                    <div class="col-md-3">
                        <label>Company Name</label>
                        <input type="text" class="form-control" name="company_name" required>
                    </div>
                </div>

                <!-- Courier -->
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label>Courier Charge</label>
                        <input type="number" step="0.01" class="form-control" name="courier_charge" required>
                    </div>
                    <div class="col-md-3">
                        <label>Number of Products</label>
                        <input type="number" class="form-control" id="num_products" min="1" value="1">
                    </div>
                    <div class="col-md-3 align-self-end">
                        <button type="button" class="btn btn-success" onclick="addRows()">Generate Rows</button>
                    </div>
                </div>

                <!-- Product Table -->
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead class="table-dark">
                            <tr>
                                <th>Item Name</th>
                                <th>Particular</th>
                                <th>Specification</th>
                                <th>Model</th>
                                <th>Qty</th>
                                <th>Rate</th>
                                <th>GST %</th>
                                <th>Fault Count</th>
                                <th>Fault Remarks</th>
                            </tr>
                        </thead>
                        <tbody id="product_body"></tbody>
                    </table>
                </div>

                <div class="text-center mt-3" id="submit_section" style="display:none;">
                    <button type="submit" class="btn btn-success">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
function addRows() {
    let num = parseInt(document.getElementById('num_products').value);
    let tbody = document.getElementById('product_body');
    tbody.innerHTML = "";

    for (let i = 0; i < num; i++) {
        let row = `
        <tr>
            <td><input type="text" class="form-control" name="item_name[]" required></td>
            <td><input type="text" class="form-control" name="particular_name[]"></td>
            <td><input type="text" class="form-control" name="specification[]"></td>
            <td><input type="text" class="form-control" name="model_number[]"></td>
            <td><input type="number" class="form-control" name="qty[]" required></td>
            <td><input type="number" step="0.01" class="form-control" name="rate[]" required></td>
            <td><input type="number" step="0.01" class="form-control" name="gst[]"></td>
            <td><input type="number" class="form-control" name="fault_count[]"></td>
            <td><input type="text" class="form-control" name="fault_remarks[]"></td>
        </tr>`;
        tbody.innerHTML += row;
    }

    document.getElementById("submit_section").style.display = "block";
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Inventorypage\stockapp\resources\views/purchase.blade.php ENDPATH**/ ?>