

<?php $__env->startSection('content'); ?>
<div class="container mt-2">
    <h2 class="mb-3 text-center text-danger">Fault Stock View</h2>

    <!-- Filter Form -->
    <form method="GET" class="row g-3 mb-4">
        <div class="col-md-3">
            <input type="text" class="form-control" name="item_name"
                   placeholder="Filter by Item" value="<?php echo e(request('item_name')); ?>">
        </div>
        <div class="col-md-3">
            <input type="text" class="form-control" name="given_to"
                   placeholder="Filter by Given To" value="<?php echo e(request('given_to')); ?>">
        </div>
        <div class="col-md-3">
            <input type="date" class="form-control" name="fault_date"
                   value="<?php echo e(request('fault_date')); ?>">
        </div>
        <div class="col-md-3 d-flex gap-2">
            <button class="btn btn-danger" type="submit">Filter</button>
            <a href="<?php echo e(route('fault_view')); ?>" class="btn btn-secondary">Reset</a>
        </div>
    </form>

    <!-- Table -->
    <table class="table table-bordered table-striped shadow-sm">
        <thead class="table-dark text-center">
            <tr>
                <th>ID</th>
                <th>Invoice Number</th>
                <th>Fault Date</th>
                <th>Given To</th>
                <th>Item</th>
                <th>Particular</th>
                <th>Specification</th>
                <th>Model</th>
                <th>Qty</th>
                <th>Remarks</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $faults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($row->id); ?></td>
                    <td><?php echo e($row->purchaseStock->invoice_number ?? 'N/A'); ?></td>
                    <td><?php echo e($row->fault_date); ?></td>
                    <td><?php echo e($row->given_to); ?></td>
                    <td><?php echo e($row->purchaseStock->item_name ?? $row->item_name); ?></td>
                    <td><?php echo e($row->purchaseStock->particular_name ?? $row->particular_name ?? '0'); ?></td>
                    <td><?php echo e($row->purchaseStock->specification ?? $row->specification ?? '0'); ?></td>
                    <td><?php echo e($row->purchaseStock->model_number ?? $row->model_number ?? '0'); ?></td>
                    <td><?php echo e($row->qty ?? '0'); ?></td>
                    <td><?php echo e($row->remarks); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="10" class="text-center text-danger">No records found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <?php echo e($faults->withQueryString()->links()); ?>

</div>

 <footer class="text-center py-3  bg-white" style="margin-top: 380px;" >
        Powered By <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Inventorypage\stockapp\resources\views/fault_view.blade.php ENDPATH**/ ?>