

<?php $__env->startSection('content'); ?>
<div class="container mt-2">
    <h2 class="mb-4 text-center text-primary">Net Stock</h2>

    <form method="GET" id="searchForm" class="row g-3 mb-4 justify-content-center text-center">
        <div class="col-md-3">
            <select class="form-select" name="report_type" onchange="this.form.submit()">
                <option value="inward" <?php echo e($reportType=='inward'?'selected':''); ?>>Inward</option>
                <option value="outward" <?php echo e($reportType=='outward'?'selected':''); ?>>Outward</option>
            </select>
        </div>
        <div class="col-md-3">
            <input type="text" name="search" class="form-control" placeholder="Search"
                   value="<?php echo e($search); ?>" onkeyup="this.form.submit()">
        </div>
        <div class="col-md-2 d-flex gap-2">
            <a href="<?php echo e(route('reports_pdf',['report_type'=>$reportType,'search'=>$search])); ?>" class="btn btn-success">Export PDF</a>
        </div>
    </form>

    <div class="table-responsive shadow-sm bg-white rounded p-2">
        <table class="table table-bordered table-striped text-center">
            <thead class="table-dark">
                <tr>
                    <?php $__currentLoopData = $columns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th><?php echo e($label); ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <?php $__currentLoopData = array_keys($columns); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td><?php echo e($row->$col ?? 0); ?></td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="<?php echo e(count($columns)); ?>" class="text-center text-danger">No records found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php echo e($records->links()); ?>

</div>

 <footer class="text-center py-3  bg-white" style="margin-top: 305px;" >
        Powered By <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Inventorypage\stockapp\resources\views/reports.blade.php ENDPATH**/ ?>