

<?php $__env->startSection('content'); ?>
<div class="container mt-2">
    <h2 class="text-center text-success mb-4" style="margin-top:-10px;">Inventory Stock</h2>

    <!-- Filters -->
    <form method="GET" action="<?php echo e(route('inventory')); ?>" class="row g-3 mb-4 justify-content-center">
        <div class="col-md-2" style="margin-right: -5px;">
            <input type="text" class="form-control" name="invoice_number" placeholder="Filter by Invoice"
                   value="<?php echo e(request('invoice_number')); ?>">
        </div>
        <div class="col-md-2" style="margin-right: -5px;">
            <input type="text" class="form-control" name="item_name" placeholder="Filter by Item"
                   value="<?php echo e(request('item_name')); ?>">
        </div>
        <div class="col-md-2"style="margin-right: -5px;">
            <input type="date" class="form-control" name="incoming_date" value="<?php echo e(request('incoming_date')); ?>">
        </div>
        <div class="col-md-3 d-flex gap-2" >
            <button class="btn btn-success" type="submit">Filter</button>
            <a href="<?php echo e(route('inventory')); ?>" class="btn btn-secondary">Reset</a>
        </div>
    </form>

    <!-- Inventory Table -->
    <table class="table table-bordered table-striped shadow-sm">
        <thead class="table-dark text-center">
            <tr>
                <th>Invoice</th>
                <th>Date</th>
                <th>Courier</th>
                <th>Item</th>
                <th>Particular</th>
                <th>Specification</th>
                <th>Model</th>
                <th>Purchased Qty</th>
                <th>Outward Qty</th>
                <th>Fault Qty</th>
                <th>Available Stock</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $purchased = (int)$row->purchased_qty;
                $outward   = (int)$row->outward_qty;
                $fault     = (int)$row->fault_qty;
                $available = $purchased - ($outward + $fault);
            ?>
            <tr>
                <td><?php echo e($row->invoice_number); ?></td>
                <td><?php echo e($row->incoming_date); ?></td>
                <td><?php echo e($row->courier_name); ?></td>
                <td><?php echo e($row->item_name); ?></td>
                <td><?php echo e($row->particular_name); ?></td>
                <td><?php echo e($row->specification); ?></td>
                <td><?php echo e($row->model_number); ?></td>
                <td class="text-center"><?php echo e($purchased); ?></td>
                <td class="text-center"><?php echo e($outward); ?></td>
                <td class="text-center"><?php echo e($fault); ?></td>
                <td class="text-center fw-bold <?php echo e($available <= 0 ? 'text-danger' : 'text-success'); ?>">
                    <?php echo e($available); ?>

                </td>
                <td class="text-center">
                    <a href="<?php echo e(url('edit_product/'.$row->id.'/edit')); ?>" class="btn btn-sm btn-warning">Edit</a>
                    <form action="<?php echo e(url('delete_product/'.$row->id)); ?>" method="POST" class="d-inline"
                          onsubmit="return confirm('Are you sure you want to delete this record?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-sm btn-danger">Delete</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="12" class="text-center text-danger">No records found</td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>

    <div class="d-flex justify-content-center">
        <?php echo e($stocks->links()); ?>

    </div>
</div>

 <footer class="text-center py-3  bg-white" style="margin-top: 315px;" >
        Powered By <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Inventorypage\stockapp\resources\views/inventory.blade.php ENDPATH**/ ?>