

<?php $__env->startSection('content'); ?>
<div class="container mt-2">
    <h2 class="mb-4 text-center text-success">Outward Stock View</h2>

    <!-- Filter Form -->
    <form method="GET" class="row g-3 mb-4">
        <div class="col-md-3">
            <input type="text" class="form-control" name="item_name" placeholder="Filter by Item" value="<?php echo e(request('item_name')); ?>">
        </div>
        <div class="col-md-3">
            <input type="text" class="form-control" name="given_to" placeholder="Filter by Given To" value="<?php echo e(request('given_to')); ?>">
        </div>
        <div class="col-md-3">
            <input type="date" class="form-control" name="outward_date" value="<?php echo e(request('outward_date')); ?>">
        </div>
        <div class="col-md-3 d-flex gap-2">
            <button class="btn btn-success" type="submit">Filter</button>
            <a href="<?php echo e(route('outward_view')); ?>" class="btn btn-secondary">Reset</a>
        </div>
    </form>

    <!-- Table -->
    <table class="table table-bordered table-striped shadow-sm">
        <thead class="table-dark text-center">
            <tr>
                <th>OS Number</th>
                <th>Invoice</th>
                <th>Outward Date</th>
                <th>Given To</th>
                <th>Item</th>
                <th>Particular</th>
                <th>Specification</th>
                <th>Model</th>
                <th>Qty</th>
                <th>Remarks</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($row->os_number); ?></td>
                    <td><?php echo e($row->purchaseStock->invoice_number ?? 'N/A'); ?></td>
                    <td><?php echo e($row->outward_date); ?></td>
                    <td><?php echo e($row->given_to); ?></td>
                    <td><?php echo e($row->purchaseStock->item_name ?? ''); ?></td>
                    <td><?php echo e($row->purchaseStock->particular_name ?? ''); ?></td>
                    <td><?php echo e($row->purchaseStock->specification ?? ''); ?></td>
                    <td><?php echo e($row->purchaseStock->model_number ?? ''); ?></td>
                    <td><?php echo e($row->qty); ?></td>
                    <td><?php echo e($row->remarks); ?></td>
                    <td class="text-center">
                        <a href="<?php echo e(url('outward/'.$row->id.'/edit')); ?>" class="btn btn-sm btn-warning">Edit</a>
                        <button class="btn btn-sm btn-danger delete-btn" data-id="<?php echo e($row->id); ?>">Delete</button>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="11" class="text-center text-danger">No records found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <?php echo e($stocks->withQueryString()->links()); ?>

</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', function () {
            if (!confirm('Are you sure you want to delete this record?')) return;

            fetch(`/outward/${this.dataset.id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Content-Type': 'application/json'
                }
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) location.reload();
                else alert('Error deleting record');
            });
        });
    });
});
</script>

 <footer class="text-center py-3  bg-white" style="margin-top: 321px;" >
        Powered By <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Loganathan\Work\stockapp\resources\views/outward_view.blade.php ENDPATH**/ ?>