

<?php $__env->startSection('title','Outward Stock Entry'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h2 class="text-center text-success">Outward Stock Entry</h2>

    <?php if(session('success')): ?>
        <div class="alert alert-success text-center"><?php echo e(session('success')); ?></div>
    <?php elseif(session('error')): ?>
        <div class="alert alert-danger text-center"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('outward.store')); ?>" class="row g-2 shadow p-3 bg-white rounded">
        <?php echo csrf_field(); ?>

        <div class="col-md-4">
            <label class="form-label">Outward Date</label>
            <input type="date" class="form-control" name="outward_date" required>
        </div>
        <div class="col-md-4">
            <label class="form-label">Given To</label>
            <input type="text" class="form-control" name="given_to" required>
        </div>
        <div class="col-md-4">
            <label class="form-label">Item</label>
            <select name="purchase_stock_id" class="form-select" required onchange="updateQtyLimit(this)">
                <option value="">-- Select Item --</option>
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($item->purchase_stock_id); ?>" data-available="<?php echo e($item->available_qty); ?>">
                        <?php echo e($item->item_name); ?> | <?php echo e($item->particular_name); ?> | <?php echo e($item->specification); ?> | <?php echo e($item->model_number); ?> (Available: <?php echo e($item->available_qty); ?>)
                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="col-md-4">
            <label class="form-label">Quantity</label>
            <input type="number" class="form-control" id="qtyInput" name="qty" min="1" required>
            <small class="text-muted" id="availableInfo"></small>
        </div>
        <div class="col-md-4">
            <label class="form-label">Remarks</label>
            <input type="text" class="form-control" name="remarks">
        </div>
        <div class="col-12 text-center">
            <button type="submit" class="btn btn-success">Submit</button>
        </div>
    </form>
</div>

 <footer class="text-center py-3  bg-white" style="margin-top: 310px;" >
        Powered By <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>
<script>
function updateQtyLimit(sel){
    const available = sel.options[sel.selectedIndex].getAttribute('data-available');
    const qtyInput = document.getElementById('qtyInput');
    const info = document.getElementById('availableInfo');
    if(available){
        qtyInput.max = available;
        qtyInput.value = (available > 0 ? 1 : 0);
        info.innerText = "Available: " + available;
    } else {
        qtyInput.max = 0;
        qtyInput.value = 0;
        info.innerText = "";
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Loganathan\Work\stockapp\resources\views/outward.blade.php ENDPATH**/ ?>