

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h2 class="text-center text-success mb-4">Return of Products</h2>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('return.store')); ?>" class="row g-3 shadow p-4 bg-white rounded">
        <?php echo csrf_field(); ?>

        <div class="col-md-4">
            <label class="form-label">Return Date</label>
            <input type="date" class="form-control" name="return_date" required>
        </div>

        <div class="col-md-4">
            <label class="form-label">OS Number</label>
            <select class="form-select" name="os_number" id="os_number" required>
                <option value="">-- Select OS Number --</option>
                <?php $__currentLoopData = $os_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $os): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($os); ?>"><?php echo e($os); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="col-md-4">
            <label class="form-label">Given To</label>
            <input type="text" class="form-control" name="given_to" id="given_to" readonly required>
        </div>

        <div class="col-md-4">
            <label class="form-label">Item Name</label>
            <input type="text" class="form-control" name="item_name" id="item_name" readonly required>
        </div>

        <div class="col-md-4">
            <label class="form-label">Particular Name</label>
            <input type="text" class="form-control" name="particular_name" id="particular_name" readonly required>
        </div>

        <div class="col-md-4">
            <label class="form-label">Specification</label>
            <input type="text" class="form-control" name="specification" id="specification" readonly required>
        </div>

        <div class="col-md-4">
            <label class="form-label">Model Number</label>
            <input type="text" class="form-control" name="model_number" id="model_number" readonly required>
        </div>

        <div class="col-md-4">
            <label class="form-label">Quantity</label>
            <input type="number" class="form-control" name="qty" id="qty" min="1" required>
        </div>

        <div class="col-md-4">
            <label class="form-label">Status</label>
            <select class="form-select" name="status" required>
                <option value="">-- Select Status --</option>
                <option value="OK">OK</option>
                <option value="Not OK">Not OK</option>
            </select>
        </div>

        <div class="col-md-4">
            <label class="form-label">Remarks</label>
            <input type="text" class="form-control" name="remarks" id="remarks">
        </div>

        <input type="hidden" name="purchase_stock_id" id="purchase_stock_id">

        <div class="col-12 text-center">
            <button type="submit" class="btn btn-success">Process Return</button>
        </div>
    </form>
</div>


 <footer class="text-center py-3  bg-white" style="margin-top: 100px;" >
        Powered By <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="Logo" style="height:22px; vertical-align:middle;">
    </footer>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function(){
    $('#os_number').change(function(){
        var os_number = $(this).val();
        console.log("Selected OS: " + os_number);

        if(os_number !== '') {
            $.post("<?php echo e(route('return.getOutward')); ?>",
                {
                    os_number: os_number,
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                function(data){
                    console.log("Response:", data);

                    $('#item_name').val(data.item_name);
                    $('#particular_name').val(data.particular_name);
                    $('#specification').val(data.specification);
                    $('#model_number').val(data.model_number);
                    $('#qty').val(data.qty);
                    $('#given_to').val(data.given_to);
                    $('#purchase_stock_id').val(data.purchase_stock_id);
                }
            );
        }
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Inventorypage\stockapp\resources\views/return_products.blade.php ENDPATH**/ ?>