<?php
session_start();
include 'db.php';

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT * FROM users WHERE username=? LIMIT 1");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows === 1) {
        $user = $res->fetch_assoc();
        if (password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['user_id'];
            $_SESSION['username'] = $user['username'];
            header("Location: inventory.php");
            exit;
        } else {
            $error = "Invalid password!";
        }
    } else {
        $error = "User not found!";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Login - Inventory</title>
    <link rel="icon" type="image/png" href="assets/logo/logo_icon.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body style="margin:0; display:flex; flex-direction:column; min-height:100vh; bg-color:#000;" class="bg-light">

    <!-- Main Content -->
    <div style="flex:1;">
        <div class="container mt-5" style="max-width: 400px;">

            <!-- Centered Logo -->
            <div class="text-center mb-4">
                <a class="navbar-brand" href="inventory.php">
                    <img src="assets/logo/logo.png" alt="Nilatech Inventory" height="60">
                </a>
            </div>

            <h3 class="text-center mb-4">Login</h3>

            <!-- Error Message -->
            <?php if ($error): ?>
                <div class="alert alert-danger text-center"><?= $error ?></div>
            <?php endif; ?>

            <!-- Login Form -->
            <form method="post" class="card p-4 shadow">
                <div class="mb-3">
                    <label class="form-label">Username</label>
                    <input type="text" name="username" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input type="password" name="password" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-success w-100">Login</button>
            </form>
        </div>
    </div>

    <!-- Footer -->
    <footer style="background:#f8f9fa; text-align:center; padding:10px 0;">
        Powered By <img src="assets/logo/logo.png" alt="Logo" style="height:20px; vertical-align:middle;">
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
