<?php
include 'db.php';
include 'auth_check.php';

$msg = "";

// Get product ID
if (!isset($_GET['id'])) {
    die("Product ID is required.");
}

$id = intval($_GET['id']);

// Fetch existing product
$result = $conn->query("SELECT * FROM purchase_stock WHERE id=$id");
if ($result->num_rows == 0) {
    die("Product not found.");
}

$product = $result->fetch_assoc();

// Fetch existing fault remarks for this product from fault_stock
$fault_remarks = '';
$fault_res = $conn->query("SELECT remarks FROM fault_stock 
    WHERE item_name='{$conn->real_escape_string($product['item_name'])}' 
    AND particular_name='{$conn->real_escape_string($product['particular_name'])}' 
    AND model_number='{$conn->real_escape_string($product['model_number'])}' 
    LIMIT 1");

if ($fault_res && $fault_res->num_rows > 0) {
    $fault_row = $fault_res->fetch_assoc();
    $fault_remarks = $fault_row['remarks'] ?? '';
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $invoice = $conn->real_escape_string($_POST['invoice_number']);
    $incoming_date = $conn->real_escape_string($_POST['incoming_date']);
    $courier = $conn->real_escape_string($_POST['courier_name']);
    $item = $conn->real_escape_string($_POST['item_name']);
    $particular = $conn->real_escape_string($_POST['particular_name']);
    $spec = $conn->real_escape_string($_POST['specification']);
    $model = $conn->real_escape_string($_POST['model_number']);

    $qty = floatval($_POST['qty']);
    $rate = floatval($_POST['rate']);
    $gst = floatval($_POST['gst']);

    $fault_raw = isset($_POST['fault_count']) ? trim($_POST['fault_count']) : '';
    if ($fault_raw === '') {
        $fault_count = null;
        $fault_count_sql = "NULL";
    } else {
        $fault_count = intval($fault_raw);
        $fault_count_sql = $fault_count;
    }

    $fault_remarks = isset($_POST['remarks']) ? $conn->real_escape_string(trim($_POST['remarks'])) : '';

    // Validation
    if ($qty < 0) {
        $msg = "Quantity cannot be negative.";
    } elseif ($fault_count !== null && $fault_count < 0) {
        $msg = "Fault Quantity cannot be negative.";
    } elseif ($fault_count !== null && $fault_count > $qty) {
        $msg = "Fault Quantity cannot exceed Purchase Quantity.";
    } elseif ($fault_count !== null && $fault_count > 0 && $fault_remarks === '') {
        $msg = "Remarks are required for fault quantity.";
    } else {
        $total = ($qty * $rate) + $gst;
        $conn->begin_transaction();

        try {
            // Update purchase_stock
            $sql = "UPDATE purchase_stock SET
                        invoice_number='$invoice',
                        incoming_date='$incoming_date',
                        courier_name='$courier',
                        item_name='$item',
                        particular_name='$particular',
                        specification='$spec',
                        model_number='$model',
                        qty=$qty,
                        rate=$rate,
                        gst=$gst,
                        total=$total,
                        fault_count=$fault_count_sql
                    WHERE id=$id";

            if (!$conn->query($sql)) throw new Exception($conn->error);

            // Update fault_stock
            if ($fault_count === null) {
                $conn->query("DELETE FROM fault_stock 
                            WHERE item_name='$item' 
                                AND model_number='$model' 
                                AND particular_name='$particular'");
            } else {
                $res = $conn->query("SELECT id FROM fault_stock 
                                    WHERE item_name='$item' 
                                    AND model_number='$model' 
                                    AND particular_name='$particular'");
                if ($res->num_rows > 0) {
                    $conn->query("UPDATE fault_stock 
                                SET qty=$fault_count, 
                                    remarks='$fault_remarks', 
                                    fault_date=NOW(), 
                                    given_to='Nilatech (admin)', 
                                    updated_at=NOW() 
                                WHERE item_name='$item' 
                                    AND model_number='$model' 
                                    AND particular_name='$particular'");
                } else {
                    $conn->query("INSERT INTO fault_stock 
                                (item_name, model_number, particular_name, specification, qty, remarks, fault_date, given_to, created_at, updated_at)
                                VALUES ('$item', '$model', '$particular', '$spec', $fault_count, '$fault_remarks', NOW(), 'Nilatech (admin)', NOW(), NOW())");
                }
            }

            $conn->commit();
            header("Location: inventory.php");
            exit;
        } catch (Exception $e) {
            $conn->rollback();
            $msg = "Error: " . $e->getMessage();
        }
    }
}
?>


<!DOCTYPE html>
<html>
<head>
    <title>Edit Product</title>
    <link rel="icon" type="image/png" href="assets/logo/logo_icon.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body { display: flex; flex-direction: column; min-height: 100vh; }
        .flex-grow-1 { flex: 1; }
        footer { background: #f8f9fa; padding: 10px 0; }
    </style>
</head>
<body class="bg-light">
<?php
if (session_status() == PHP_SESSION_NONE) session_start();
include 'navbar.php';
?>

<div class="flex-grow-1">
    <div class="container mt-2">
        <h2 class="text-center text-primary mb-4">Edit Product</h2>

        <?php if($msg != "") { ?>
            <div class="alert alert-info text-center"><?php echo htmlspecialchars($msg); ?></div>
        <?php } ?>

        <form method="POST">
            <div class="row g-3 mb-3">
                <div class="col-md-4">
                    <label class="form-label">Invoice Number</label>
                    <input type="text" class="form-control" name="invoice_number" value="<?php echo htmlspecialchars($product['invoice_number']); ?>" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Date</label>
                    <input type="date" class="form-control" name="incoming_date" value="<?php echo htmlspecialchars($product['incoming_date']); ?>" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Courier Name</label>
                    <input type="text" class="form-control" name="courier_name" value="<?php echo htmlspecialchars($product['courier_name']); ?>">
                </div>
            </div>

            <div class="row g-3 mb-3">
                <div class="col-md-3">
                    <label class="form-label">Item Name</label>
                    <input type="text" class="form-control" name="item_name" value="<?php echo htmlspecialchars($product['item_name']); ?>" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Particular</label>
                    <input type="text" class="form-control" name="particular_name" value="<?php echo htmlspecialchars($product['particular_name']); ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Specification</label>
                    <input type="text" class="form-control" name="specification" value="<?php echo htmlspecialchars($product['specification']); ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Model</label>
                    <input type="text" class="form-control" name="model_number" value="<?php echo htmlspecialchars($product['model_number']); ?>">
                </div>
            </div>

            <div class="row g-3 mb-3">
                <div class="col-md-2">
                    <label class="form-label">Qty</label>
                    <input type="number" class="form-control" name="qty" id="qty" value="<?php echo htmlspecialchars($product['qty']); ?>" min="0" step="any" required>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Rate</label>
                    <input type="number" step="0.01" class="form-control" name="rate" value="<?php echo htmlspecialchars($product['rate']); ?>" required>
                </div>
                <div class="col-md-2">
                    <label class="form-label">GST %</label>
                    <input type="number" step="0.01" class="form-control" name="gst" value="<?php echo htmlspecialchars($product['gst']); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Fault Count</label>
                    <input type="number" class="form-control" name="fault_count" id="fault_count"
                        value="<?php echo ($product['fault_count'] === null ? '' : htmlspecialchars($product['fault_count'])); ?>"
                        min="0" step="1" max="<?php echo htmlspecialchars($product['qty']); ?>">
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label">Fault Remarks</label>
                <textarea class="form-control" name="remarks" rows="2"><?php 
                    echo htmlspecialchars($fault_remarks, ENT_QUOTES);
                ?></textarea>
            </div>

            <div class="text-center mt-3">
                <button type="submit" class="btn btn-success">Update Product</button>
                <a href="inventory.php" class="btn btn-secondary">Back</a>
            </div>
        </form>
    </div>
</div>

<?php
if (session_status() == PHP_SESSION_NONE) session_start();
include 'footer.php';
?>

<script>
const qtyInput = document.getElementById('qty');
const faultInput = document.getElementById('fault_count');

function updateFaultMax() {
    let qty = parseFloat(qtyInput.value);
    if (isNaN(qty) || qty < 0) qty = 0;
    faultInput.max = qty;

    if (faultInput.value !== '' && parseFloat(faultInput.value) > qty) {
        faultInput.value = (Number.isInteger(qty) ? parseInt(qty) : qty);
    }
}

faultInput.addEventListener('input', function() {
    if (this.value === '') return;
    let val = parseInt(this.value);
    if (isNaN(val)) { this.value = ''; return; }
    if (val < 0) this.value = 0;
    let max = parseFloat(qtyInput.value);
    if (isNaN(max) || max < 0) max = 0;
    if (val > max) this.value = Math.floor(max);
});

qtyInput.addEventListener('input', updateFaultMax);
updateFaultMax();
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
