<?php
include 'db.php';
include 'auth_check.php';

$msg = "";

// Fetch items with available quantity
$item_query = "
    SELECT 
        ps.item_name, ps.particular_name, ps.specification, ps.model_number,
        SUM(ps.qty) 
        - IFNULL(SUM(os.qty),0) 
        - IFNULL(SUM(fs.qty),0) AS available_qty,
        ps.id
    FROM purchase_stock ps
    LEFT JOIN outward_stock os 
           ON ps.item_name = os.item_name
           AND ps.particular_name = os.particular_name
           AND ps.specification = os.specification
           AND ps.model_number = os.model_number
    LEFT JOIN fault_stock fs
           ON ps.item_name = fs.item_name
           AND ps.particular_name = fs.particular_name
           AND ps.specification = fs.specification
           AND ps.model_number = fs.model_number
    GROUP BY ps.item_name, ps.particular_name, ps.specification, ps.model_number, ps.id
    HAVING available_qty > 0
    ORDER BY ps.item_name ASC
";

$items_result = $conn->query($item_query);

// Handle Add Outward Entry
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_outward'])) {
    $outward_date = $_POST['outward_date'];
    $given_to = trim($_POST['given_to']);
    $item = trim($_POST['item_name']);
    $particular = trim($_POST['particular_name']);
    $spec = trim($_POST['specification']);
    $model = trim($_POST['model_number']);
    $qty = intval($_POST['qty']);
    $remarks = trim($_POST['remarks']);

    // Check available quantity
    $check_qty_sql = "
        SELECT 
            SUM(ps.qty) 
            - IFNULL(SUM(os.qty),0) 
            - IFNULL(SUM(fs.qty),0) AS available_qty
        FROM purchase_stock ps
        LEFT JOIN outward_stock os 
            ON ps.item_name = os.item_name
            AND ps.particular_name = os.particular_name
            AND ps.specification = os.specification
            AND ps.model_number = os.model_number
        LEFT JOIN fault_stock fs
            ON ps.item_name = fs.item_name
            AND ps.particular_name = fs.particular_name
            AND ps.specification = fs.specification
            AND ps.model_number = fs.model_number
        WHERE TRIM(ps.item_name)='$item'
        AND TRIM(ps.particular_name)='$particular'
        AND TRIM(ps.specification)='$spec'
        AND TRIM(ps.model_number)='$model'
        GROUP BY ps.item_name, ps.particular_name, ps.specification, ps.model_number
    ";

    $check_qty_result = $conn->query($check_qty_sql);
    $check_qty = $check_qty_result ? $check_qty_result->fetch_assoc() : null;

    if (!$check_qty) {
        $msg = "Selected item combination not found in stock!";
    } elseif ($qty > $check_qty['available_qty']) {
        $msg = "Requested quantity exceeds available stock!";
    } else {
        // Generate OS number
        $prefix = "OS";
        $last = $conn->query("SELECT os_number FROM outward_stock ORDER BY id DESC LIMIT 1");
        $lastNumber = ($last && $last->num_rows>0) ? intval(substr($last->fetch_assoc()['os_number'],2)) : 0;
        $os_number = $prefix . str_pad($lastNumber + 1, 6, '0', STR_PAD_LEFT);

        $sql = "INSERT INTO outward_stock (outward_date, given_to, item_name, particular_name, specification, model_number, qty, remarks, os_number)
                VALUES ('$outward_date','$given_to','$item','$particular','$spec','$model','$qty','$remarks','$os_number')";
        if ($conn->query($sql)) {
            // $msg = "Outward entry added successfully! OS Number: $os_number";
            header("Location: outward_view.php");
            exit;
        } else {
            $msg = "Error: ".$conn->error;
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Outward Stock</title>
    <link rel="icon" type="image/png" href="assets/logo/logo_icon.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* Ensure footer stays at bottom */
        body { display: flex; flex-direction: column; min-height: 100vh; }
        .flex-grow-1 { flex: 1; }
        footer { background: #f8f9fa; padding: 10px 0; }
    </style>
</head>
<body class="bg-light">

<?php include 'navbar.php'; ?>

<div class="flex-grow-1">
    <div class="container mt-2">
        <h2 class="mb-4 text-center text-success">Outward Stock Entry</h2>

        <?php if($msg != "") { ?>
            <div class="alert alert-info text-center"><?= $msg ?></div>
        <?php } ?>

        <!-- Add Outward Form -->
        <form method="POST" class="row g-2 shadow p-2 bg-white rounded mb-3">
            <input type="hidden" name="add_outward" value="1">
            <div class="col-md-4">
                <label class="form-label">Outward Date</label>
                <input type="date" class="form-control" name="outward_date" required>
            </div>
            <div class="col-md-4">
                <label class="form-label">Given To</label>
                <input type="text" class="form-control" name="given_to" required>
            </div>
            <div class="col-md-4">
                <label class="form-label">Item</label>
                <select name="item_name_full" class="form-select" required onchange="updateDetails(this)">
                    <option value="">-- Select Item --</option>
                    <?php
                    $items_result->data_seek(0);
                    while($row = $items_result->fetch_assoc()){
                        $value = $row['item_name'].'||'.$row['particular_name'].'||'.$row['specification'].'||'.$row['model_number'].'||'.$row['available_qty'];
                        echo "<option value='$value'>".$row['item_name']." | ".$row['particular_name']." | ".$row['specification']." | ".$row['model_number']." (Available: ".$row['available_qty'].")</option>";
                    }
                    ?>
                </select>
            </div>

            <!-- Hidden fields -->
            <input type="hidden" name="item_name">
            <input type="hidden" name="particular_name">
            <input type="hidden" name="specification">
            <input type="hidden" name="model_number">

            <div class="col-md-4">
                <label class="form-label">Quantity</label>
                <input type="number" class="form-control" id="qtyInput" name="qty" min="1" required>
            </div>
            <div class="col-md-4">
                <label class="form-label">Remarks</label>
                <input type="text" class="form-control" name="remarks">
            </div>
            <div class="col-12 text-center">
                <button type="submit" class="btn btn-success">Submit</button>
            </div>
        </form>
    </div>
</div>

<?php
if (session_status() == PHP_SESSION_NONE) session_start();
include 'footer.php';
?>

<script>
function updateDetails(sel){
    if(sel.value){
        const parts = sel.value.split('||');
        const itemName = parts[0].trim();
        const particularName = parts[1].trim();
        const specification = parts[2].trim();
        const modelNumber = parts[3].trim();
        const availableQty = parseInt(parts[4]); 

        // Fill hidden fields
        document.querySelector('input[name="item_name"]').value = itemName;
        document.querySelector('input[name="particular_name"]').value = particularName;
        document.querySelector('input[name="specification"]').value = specification;
        document.querySelector('input[name="model_number"]').value = modelNumber;

        // Set max quantity
        const qtyInput = document.getElementById('qtyInput');
        qtyInput.max = availableQty;
        qtyInput.value = availableQty > 0 ? 1 : 0;
    }
}

document.getElementById('qtyInput').addEventListener('input', function() {
    const max = parseInt(this.max);
    if(parseInt(this.value) > max){
        this.value = max;
    }
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
